/**
 *
 * \file        cresnet_host.h
 *
 * \brief       header file for
 *              low level uart hardware class as a foundation for CresnetTask class
 *
 * \author      Gennady
 *
 * \date        8/24/2008
 *
 */
#ifndef _DM_CRESNET_HOST_H_
#define _DM_CRESNET_HOST_H_

#include "dm_cresnet.h"
#include "dm_errors.h"
#include <string.h>
#include "dm_os.h"
#include "dm_uart_cresnet_master.h"
#include "dm_console.h"
//#include <ctype.h>
#include "dm_cip.h"
#include "memorymanager.h"
#include <stdlib.h>
#include <stdio.h>

#include "dm_CresnetHardware.hpp"
#include "dm_OsEvent.hpp"
#include "DmEncapChecksumHelper.h"
#include "dm_NetMapper.hpp"

// cresnet host events
extern "C" {
    typedef enum
    {
        DMH_EVENT_NONE = 0,
        DM_EVENT_READY, // sends when event is initialized
        DMH_EVENT_SYNC_DONE,          // e.g. sync is sent out
        DMH_EVENT_NO_RESPONSE,
        DMH_EVENT_EMPTY_TOKEN,
        DMH_EVENT_DATA_RECEIVED,
        DMH_EVENT_DATA_TIMEOUT, // timeout in the middle of the packet
        DMH_EVENT_DATA_ERROR,
        DMH_EVENT_FATAL_ERROR_TIMER,
        DMH_EVENT_FATAL_ERROR_UART,
        DMS_EVENT_POLL_START_SEND, // can do host poll
        DMS_EVENT_POLL_START_RECEIVED, // other task sends confirmation
        DMS_EVENT_POLL_STOP_SEND, // cannot do host poll
        DMS_EVENT_POLL_STOP_RECEIVED, // other task sends confirmation
        DMH_EVENT_INALID
    } DM_HOST_EVENTS ;
}   // end of extern "C"
#pragma pack()
class CDMCresnetUartHost
{
    private:
        void         (*m_vSpecialDevHandler)(void *, int);
    public:
        UINT8 extra[OS_TASK_EXTRA_BYTES];   // not sure what for

        static UINT8     m_iTotalDmHosts;

        //Bugzilla 41743 fix
        //Give each master it's own m_iPollState variable
        UINT8     m_PendingStopPoll;
        UINT8     m_iPollState ;
        UINT8     m_iUart ;   // which UART
        UINT8     m_iTimer ;   // which TIMER
        UINT8     m_iDmNet ;   // which DmNet - output cards have two DmNets
        UINT8     m_iCurrent ;   // which slave ID is polled
        UINT16    m_iBusCtrlPin ;   // which GPIO control DmNet Tx<->Rx
        UINT16    m_iDebug;
                          //
        CREST_ALL_PACKETS   m_pTxPacket ; // packet to be sent is stored here
        CREST_ALL_PACKETS   *m_pTxQueue;  // Output packet queue;  only used in reverse control flow.
                                          // set by join state only (no lock needed)
        CREST_ALL_PACKETS   m_pPacket ; // received packet is stored here

        DM_CRESNET_HOST_STATE_ENUM volatile m_iNetMode ;   // what it's doing now: sending token, wait on rcv, rcv, etc...
        int m_iRxCount ;    // -1: wait for length,valid only if m_iNetMode == DM_MASTER_STATE_WAIT_FOR_RESPONSE or STATE_RECIEVING
        int m_iRxExpected ; // -1: wait for length,valid only if m_iNetMode == DM_MASTER_STATE_WAIT_FOR_RESPONSE or STATE_RECIEVING
        UINT16 m_iTxCount ;
        UINT16 m_iTxCurrent ;
        int m_iResponded ; // 0 - no response, 1 - responded, set to 0 before every token
        UINT8 no_response_cnt;
        UINT8 report_Data_cnt;    // packet should be send to slave side
        BOOL m_bOnline;    // this corresponds to a single slave DmNet device

        UINT32 m_ilockId;      // Semaphore handle
        UINT32 m_iTaskId; //  Task handle
        CC_BaseTimer *m_pTimer;
        CC_BaseUart  *m_pUart ;
        OS_Event     *m_pEvent;      // ISR events
        OS_Event     *m_pPollEvent;  // other side, e.g. slave poll events

	    CDMNetMapper	*m_pDMNetMapper;

        //DmEncapChecksumHelper class
        DmEncapChecksumHelper* m_pEncapChecksumHelper;

        BOOL m_bEnabled;

        CDMCresnetUartHost(UINT8 DmNetSelect, UINT8 UartSelect, UINT8 TimerSelect, DmEncapChecksumHelper* pHelper = 0, CDMNetMapper *tmpDMNetMapper = pDMNetMapper );
        CDMCresnetUartHost(void);
        ~CDMCresnetUartHost() {} ;        // empty for now

        void Init(void) ;
        void SetDefaults(void) ;
        void SetUartAndTimer(UINT8 DmNetSelect, UINT8 UartSelect, UINT8 TimerSelect);
        void ResetState(void) ; // clear all the variables before polling

        INT8 ObtainCrestSema(UINT32 wait ) ;
        INT8 ReleaseCrestSema(void)  ;

        INT8 PollDevice(void) ;
        INT8 SendPacket(CREST_ALL_PACKETS *packet) ;        // send packet, wait until poll resumes
        INT8 SendToken(UINT8 cnetId) ;        // send token and wait for response
        INT8 SendSync(void);
        void StopPolling(void)  ;
        void StartPolling(void) ;

        void DmHostTask(void) ; // process received packet

        void DmHostTimerISR(void);
        void DmHostUartISR(void);
        UINT32 MasterMidpointRxIsr(void);
        INT8 DmProccessPacketRx(void);
        void DmProccessPacketTx(UINT8 Command);
        void DmSetOnLineStatus(UINT8);
        bool HostEnqueueOutgoingPacket(CREST_ALL_PACKETS *pPacket, UINT16 lLength);
        bool OutputQueueAvailable(void);
        bool IsDeviceConnected(void);
        CREST_ALL_PACKETS *DmHostGetNextPacket(void) ; // returns pointer if packet set
        void DmHostReleaseNextPacket(void) ; // returns pointer if packet set
        void DmHostSetSpecialHandler(void(*fn)(void*,int)) {m_vSpecialDevHandler= fn;};

        void Reconfigure(BOOL bEnable);
};

#ifdef __cplusplus
extern "C" {
#endif

INT32 ReportDMnetCmd(UINT32,char*);

void MasterTimer_Isr(UINT8 Timer);
void MasterUart_Isr(UINT8 Uart) ;
#ifdef __cplusplus
}
#endif

//INT8 GetNumberOfDmHosts(void);

//void print_ah_debug(char *str, UINT16 len) ;
#define  print_packet(x,s) DmConsoleHexDumpPacket((UINT8 *)(x),((UINT16)((x)[1])+2),s,0)


// global class pointers cresnet master classes
#ifndef _CRESNET_HOST_CPP_

extern CDMCresnetUartHost *g_pDmMaster[];
extern CDMCresnetUartHost *g_pDmMasterTimer[] ;
extern CDMCresnetUartHost *g_pDmMasterUart[]  ;

#endif

//Function pointers for Cresnet host processing
typedef void (*FN_MASTERPROCESSPACKET)( UINT8* pPacket );
extern FN_MASTERPROCESSPACKET pfMasterProcessPacket;

typedef void (*FN_MASTERONLINESTATUS)( UINT8 IsOnline );
extern FN_MASTERONLINESTATUS pfMasterOnlineStatus;

#endif // _DM_CRESNET_HOST_H_

